#include "EFFileOutputStream.hpp"

namespace EFramework
{
	EFFileOutputStream::EFFileOutputStream(const EFString& fileName)
	{
		//=====================================================
		// Attempt to open binary file for writing.
		//=====================================================
		mOutputFile.open(fileName.c_str(), std::ios::binary|std::ios::trunc);

		//=====================================================
		// Check if the file was opened successfully.
		//=====================================================
		if(!mOutputFile.is_open())
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Could not open binary file for writing.");
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFFileOutputStream::WriteChar(uchar& value)
	{
		mOutputFile.write((char*)&value, sizeof(uchar));
		mOutputFile.flush();
	}

	void EFFileOutputStream::WriteShort(ushort& value)
	{
		mOutputFile.write((char*)&value, sizeof(ushort));
		mOutputFile.flush();
	}

	void EFFileOutputStream::WriteInt(uint& value)
	{
		mOutputFile.write((char*)&value, sizeof(uint));
		mOutputFile.flush();
	}

	void EFFileOutputStream::WriteLong(ulong& value)
	{
		mOutputFile.write((char*)&value, sizeof(ulong));
		mOutputFile.flush();
	}

	void EFFileOutputStream::WriteBool(bool& value)
	{
		mOutputFile.write((char*)&value, sizeof(bool));
		mOutputFile.flush();
	}

	void EFFileOutputStream::WriteString(char* value, ulong size)
	{
		mOutputFile.write(value, size);
		mOutputFile.flush();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFFileOutputStream::CloseStream()
	{
		if(!mOutputFile.is_open())
		{
			mOutputFile.flush();
			mOutputFile.close();
		}
		else
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Attempted to close a binary file that is not open.");
		}
	}
} // Namespace EFramework